<?php
$wrapper_classes  = 'site-header templaza-header-section basic-header-section';
$wrapper_classes .= has_custom_logo() ? ' has-logo' : '';
$wrapper_classes .= ( true === get_theme_mod( 'display_title_and_tagline', true ) ) ? ' has-title-and-tagline' : '';
$wrapper_classes .= has_nav_menu( 'primary' ) ? ' has-menu' : '';
$blog_info    = get_bloginfo( 'name' );
$description  = get_bloginfo( 'description', 'display' );
$show_title   = ( true === get_theme_mod( 'display_title_and_tagline', true ) );
$header_class = $show_title ? 'site-title' : 'screen-reader-text';
class hotelian_Submenu_Wrap extends Walker_Nav_Menu {
    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<div class='uk-navbar-dropdown'><ul class='uk-nav uk-navbar-dropdown-nav'>\n";
    }
    function end_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "$indent</ul></div>\n";
    }
    function start_el(&$output, $item, $depth=0, $args=[], $id=0) {

        $theme_location = 'primary';
        // check for top level depth and if correct menu

        if ($depth === 0 && isset($args->menu) && isset($args->menu->slug)) {
            // get current menu items
            if($item->menu_order==1){
                $output .= '<ul class="left-logo parent-menu-item uk-navbar-center-left uk-navbar-left">';
            }
            $locations = get_nav_menu_locations();
            $menu = get_term( $locations[$theme_location], 'nav_menu' );
            $menu_items = wp_get_nav_menu_items($menu->term_id);

            // will indicate how many top level menu items we have
            $parent_menu_items = [];

            // get top level menu items

            foreach ($menu_items as $menu_item) {

                if ($menu_item->menu_item_parent == 0) $parent_menu_items[] = $menu_item;
            }

            // get total menu items halved
            $half_menu_items = floor(count($parent_menu_items) / 2);
            if (is_float($half_menu_items)) {
                // if you have odd menu items lets say three this will add after the first
                // [1] [custom html] [2] [3]
                // if you want it to add after the second remove the - 1, this will result in
                // [1] [2] [custom html] [3]
                $middle_item = $parent_menu_items[$half_menu_items ];
            } elseif (is_int($half_menu_items)) {
                // this handles even menu items
                $middle_item = $parent_menu_items[$half_menu_items ];
            }
            $end_item = count($parent_menu_items);
            if (isset($middle_item) && $middle_item->ID === $item->ID) {

                $output .= '</ul><div class="menu-logo uk-flex uk-flex-middle">';

                ob_start();
                if ( has_custom_logo()) {
                    the_custom_logo();
                }else{
                    ?>
                    <a class="templaza-logo templaza-logo-image" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img class="uk-preserve templaza-logo-default" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/logo.svg');?>" data-uk-svg>
                        <img class="uk-preserve templaza-logo-mobile" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/logo_mobile.svg');?>" data-uk-svg>
                    </a>
                    <?php
                }
                $output .= ob_get_clean();

                $output .= '</div>';
                $output .= '<ul class="right-logo parent-menu-item uk-navbar-center-right">';
            }

        }



        $output .= "<li class='" .  implode(" ", $item->classes) . "'>";

        if ($item->url && $item->url != '#') {
            $output .= '<a href="' . $item->url . '">';
        } else {
            $output .= '<span>';
        }

        $output .= $item->title;

        if ($item->url && $item->url != '#') {
            $output .= '</a>';
        } else {
            $output .= '</span>';
        }

    }
    function end_el (&$output, $item, $depth = 0, $args = [], $id = 0) {
        parent::end_el($output, $item, $depth, $args, $id);

        // the menu slug
        $theme_location = 'primary';

        // check for top level depth and if correct menu
        if ($depth === 0 && isset($args->menu) && isset($args->menu->slug)) {
            // get current menu items
            $locations = get_nav_menu_locations();
            $menu = get_term( $locations[$theme_location], 'nav_menu' );
            $menu_items = wp_get_nav_menu_items($menu->term_id);

            // will indicate how many top level menu items we have
            $parent_menu_items = [];

            // get top level menu items

            foreach ($menu_items as $menu_item) {

                if ($menu_item->menu_item_parent == 0) $parent_menu_items[] = $menu_item;
            }

            // get total menu items halved
            $half_menu_items = floor(count($parent_menu_items) / 2);

            // the menu item we want to add the logo to
            // before or after, depends if menu items are odd or even
            if (is_float($half_menu_items)) {
                // if you have odd menu items lets say three this will add after the first
                // [1] [custom html] [2] [3]
                // if you want it to add after the second remove the - 1, this will result in
                // [1] [2] [custom html] [3]
                $middle_item = $parent_menu_items[$half_menu_items - 1];
            } elseif (is_int($half_menu_items)) {
                // this handles even menu items
                $middle_item = $parent_menu_items[$half_menu_items - 1];
            }
//            if($item->menu_order == $half_menu_items){
//                $output .= '</div>';
//            }


            // if current menu item is middle item, add our custom html

        }
    }
}
if(class_exists( 'woocommerce' )){
    if(WC()->cart->get_cart_contents_count() > 0){
        $cart_pro = 'has_product';
    }else{
        $cart_pro = 'no_product';
    }
}

?>
<header id="masthead" class="tz-header-wrap <?php echo esc_attr( $wrapper_classes ); ?>" role="banner" >

    <div class="uk-padding-remove-vertical tz-header-default uk-container uk-container-large ">
        <div class="header-show-icon header-content ">
            <div class="templaza-mobile-btn ">
                <span class="open" data-uk-icon="icon: menu; ratio: 1.6"></span>
                <span class="close" data-uk-icon="icon: close; ratio: 1.6"></span>
            </div>

            <div class="templaza-header templaza-horizontal-header uk-container uk-container-large">
                <div class="uk-hidden@m uk-width-1-1 uk-text-center">
                    <?php if ( has_custom_logo()) {
                        the_custom_logo();
                    }else{
                        ?>
                        <a class="templaza-logo templaza-logo-image" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <img class="uk-preserve templaza-logo-default" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/logo.svg');?>" data-uk-svg>
                            <img class="uk-preserve templaza-logo-mobile" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/logo_mobile.svg');?>" data-uk-svg>
                        </a>
                        <?php
                    } ?>
                </div>

                <?php if ( has_nav_menu( 'primary' ) ) { ?>
                    <nav id="site-navigation" class="uk-navbar-container  uk-padding-remove templaza-basic-navbar uk-navbar-transparent">
                        <?php
                        wp_nav_menu(
                            array(
                                'theme_location'  => 'primary',
                                'menu_class'      => 'templaza-nav uk-navbar-nav',
                                'container'       => false,
                                'items_wrap'      => '<div id="primary-menu-list"  data-uk-navbar class="%2$s"><div class="uk-navbar-center" data-uk-height-match> %3$s</div></div></ul>',
                                'walker'          => new hotelian_Submenu_Wrap()
                            )
                        );
                        ?>
                    </nav><!-- #site-navigation -->
                <?php }else{
                    ?>
                    <div class="uk-width-1-1  uk-text-center uk-padding-small">
                <?php
                    if ( has_custom_logo()) {
                        the_custom_logo();
                    }else{
                        ?>
                        <a class="templaza-logo templaza-logo-image" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <img class="uk-preserve templaza-logo-default" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/logo.svg');?>" data-uk-svg>
                            <img class="uk-preserve templaza-logo-mobile" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/logo_mobile.svg');?>" data-uk-svg>
                        </a>
                        <?php
                    }
                    ?>
                    </div>
                <?php
                } ?>
            </div>

            <div class="uk-flex uk-flex-right uk-flex-middle  uk-position-center-right header-default-icon uk-margin-large-right">
                <?php if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){ ?>
                    <div class="header-cart header-icon <?php echo esc_attr($cart_pro);?>">
                        <a href="<?php echo esc_url( wc_get_cart_url() ) ?>" data-toggle="modal" data-target="cart-modal">
                            <i class="fas fa-shopping-cart"></i>
                            <span class="counter cart-counter"><?php echo esc_html(WC()->cart->get_cart_contents_count()); ?></span>
                        </a>
                    </div>
                <?php } ?>
            </div>

        </div>

    </div>
</header>